<?php
/**
 * Luxeritas WordPress Theme - free/libre wordpress platform
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @copyright Copyright (C) 2015 Thought is free.
 * @license http://www.gnu.org/licenses/gpl-2.0.html GPL v2 or later
 * @author LunaNuko
 * @link https://thk.kanzae.net/
 * @translators rakeem( http://rakeem.jp/ )
 */

// WordPress の例の定数を使うとチェックで怒られるので再定義
define( 'TPATH', get_template_directory() );
define( 'DSEP' , DIRECTORY_SEPARATOR );
define( 'INC'  , TPATH . DSEP . 'inc' . DSEP );

/*---------------------------------------------------------------------------
 * Luxeritas Theme only works in PHP 5.3 or later.
 * Luxeritas Theme only works in WordPress 4.4 or later.
 *---------------------------------------------------------------------------*/
if(
	version_compare( PHP_VERSION, '5.3', '<' ) === true ||
	version_compare( $GLOBALS['wp_version'], '4.4-alpha', '<' ) === true
) {
	require( INC . 'back-compat.php' );
	switch_theme( 'default' );
}

/*---------------------------------------------------------------------------
 * common
 *---------------------------------------------------------------------------*/
load_theme_textdomain( 'luxeritas-update', TPATH . DSEP . 'languages' );
add_theme_support( 'title-tag' );

add_filter( 'document_title_parts', function( $title ) {
	return array( 'site' => __( 'Maintenance', 'luxeritas-update' ) );
});

add_action( 'widgets_init', function() {
	register_sidebars( 1, array() );
});

/*---------------------------------------------------------------------------
 * admin
 *---------------------------------------------------------------------------*/
if( current_user_can( 'edit_theme_options' ) === true ) {
	if( stripos( $_SERVER['REQUEST_URI'], 'wp-admin/update.php' ) !== false && stripos( $_SERVER['REQUEST_URI'], 'upload-theme' ) !== false ) {
		if( isset( $_FILES['themezip']['name'] ) && substr( $_FILES['themezip']['name'], 0, 10 ) === 'luxeritas-' ) {

			add_action( 'admin_head', function() {
				global $wp_filesystem;
				if( init_filesystem( site_url() ) === false ) return false;

				$luxe_dir = str_replace( '-update', '', TPATH );
				$msg = __( 'Could not delete the luxeritas directory. Please check that the directory or file is not locked.', 'luxeritas-update' );
				$status = true;

				// all directories and files writable check.
				if( wp_is_writable( $luxe_dir ) === true ) {
					$filelist = get_file_list( $luxe_dir );
					foreach( $filelist as $val ) {
						if( wp_is_writable( $val ) === false ) $status = false;
					}
				}
				else {
					$status = false;
				}

				if( $status === true ) {
					$wp_filesystem->delete( $luxe_dir, true );
					$luxech_dir = str_replace( 'ritas-update', 'ch', TPATH );

					if( file_exists( $luxech_dir ) === true ) {
						$msg = __( 'Enable Luxeritas Child Theme. Please wait.', 'luxeritas-update' );
					}
					else {
						$msg = __( 'Enable Luxeritas Theme. Please wait.', 'luxeritas-update' );
					}
				}

				$redirect = admin_url() . 'themes.php';
echo <<<SCRIPT
<style>
#wpbody-content .wrap a {
	display: none;
	pointer-events: none;
}
</style>
<script>
jQuery( function($) {
	var target = $('#wpbody-content .wrap');
	target.ready(function() {
		console.log('target ready');
		target.append( '<p>{$msg}</p>' );

SCRIPT;
		echo $status === true ? "location.href = '{$redirect}';" : '';

echo <<<SCRIPT
	});
});
</script>
SCRIPT;
			});
			add_action( 'shutdown', function() {
				$luxech_dir = str_replace( 'ritas-update', 'ch', TPATH );
				$luxe_dir = str_replace( '-update', '', TPATH );

				if( file_exists( $luxech_dir ) === true ) {
					switch_theme( 'luxech' );
				}
				elseif( file_exists( $luxe_dir ) === true ) {
					switch_theme( 'luxeritas' );
				}
			});
		}
	}
}

/*---------------------------------------------------------------------------
 * filesystem
 *---------------------------------------------------------------------------*/
function init_filesystem( $url = null ) {
	global $wp_filesystem;
	require_once( ABSPATH . 'wp-admin/includes/file.php' );

	if( $url === null ) {
		$url = wp_nonce_url( 'customize.php?return=' . urlencode( wp_unslash( $_SERVER['REQUEST_URI'] ) ) );
	}
	$creds = request_filesystem_credentials( $url, '', false, false, null );

	// Writable or Check
	if( false === ( $creds = request_filesystem_credentials( $url, '', false, false, null ) ) ) {
		return false;
	}
	// WP_Filesystem_Base init
	if( false === WP_Filesystem( $creds ) ) {
		request_filesystem_credentials( $url, '', true, false, null );
		return false;
	}
	return;
}

function get_file_list( $dir ) {
	$files = glob( rtrim( $dir, '/' ) . '/*' );
	$ret = array();
	foreach( $files as $file ) {
		if( is_file( $file ) ) {
			$ret[] = $file;
		}
		elseif( is_dir( $file ) ) {
			$ret = array_merge( $ret, get_file_list( $file ) );
		}
	}
	return $ret;
}

/*---------------------------------------------------------------------------
 * dummy
 *---------------------------------------------------------------------------*/
function dummy_func() {
	nav_menu();
	post_class();
	posts_nav_link();
	the_post_thumbnail();
	get_the_tags();
	wp_link_pages();
	comments_template();
	paginate_comments_links();
	wp_list_comments();
	comment_form();
	dynamic_sidebar();
	add_editor_style();
	add_theme_support( "custom-header" );
	add_theme_support( "custom-background" );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "post-thumbnails" );
	wp_enqueue_script( "comment-reply" );
	if( !isset( $content_width ) ) $content_width = 1170;
}
