<?php
/**
 * Luxeritas WordPress Theme - free/libre wordpress platform
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @copyright Copyright (C) 2015 Thought is free.
 * @license http://www.gnu.org/licenses/gpl-2.0.html GPL v2 or later
 * @author LunaNuko
 * @link https://thk.kanzae.net/
 * @translators rakeem( http://rakeem.jp/ )
 */

get_header();	// HTTP response status codes 503 Service Unavailable
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> xmlns="http://www.w3.org/1999/xhtml"<?php if ( is_rtl() ) echo ' dir="rtl"'; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<?php
ob_start();
wp_head();
$head = ob_get_clean();
echo preg_replace( '/.*(<title>[^<]+?<\/title>).*/smi', '$1', $head ). "\n";
?>
</head>
<body <?php body_class(); ?>>
<h1><?php echo __( 'Briefly unavailable for scheduled maintenance. Check back in a minute.', 'luxeritas-update' ); ?></h1>
<?php
ob_start();
wp_footer();
ob_get_clean();
?>
</body>
</html>
